<?php
use Carbon\Carbon;
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <title>quiz result</title>
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/slick.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/slick-theme.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/jquery-ui.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/fontawesome/css/all.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/mona/css2/owl.theme.default.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/mona/css2/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/mona/assets/css/main.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css"
        integrity="sha512-xh6O/CkQoPOWDdYTDqeRdPCVd1SpvCA9XXcUnZS2FmJNp1coAFzvtCN9BmamE+4aHK8yyUHUSCcJHgXloTyT2A=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<body>
    <div class="main-wrapper">

        <section class="fxtemplat mb-25">

            <div class="container">
                <div class="row justify-content-center mb-25">
                    <div class="col-md-12 col-sm-6 col-lg-6 mb-5 px-0">

                        <div class="fxontent opeerr">
                            <div class="posterqpi">
                                <h3> <?php echo e($result->quiz->lesson->unit->level->course->title); ?>, Unit
                                    <?php echo e($result->quiz->lesson->unit->number); ?>,
                                    <br>Lesson<?php echo e($result->quiz->lesson->number); ?> Quiz
                                </h3>
                                <div class="imageros">
                                    <?php if(!empty(auth()->user()->image)): ?>
                                        <img src="<?php echo e(asset(auth()->user()->image)); ?>">
                                    <?php endif; ?>
                                </div>
                                <div class="imaos"><img src="<?php echo e(asset('assets/img/Group920@2x.png')); ?>"></div>
                                <div class="chart25">


                                    <h2>Nice Try!</h2>
                                    <p>
                                        <span class="numbers">

                                            <span
                                                class="mastered-number in-progress"><?php echo e($result->total_degree); ?></span>
                                            <span class="total-number">/<?php echo e(count($lesson->quiz->questions)); ?></span>
                                        </span>
                                    </p>
                                    <?php if($result->total_degree < 4): ?>
                                        <p class="textpo">Almost there! We recommend retaking the quiz and trying to get
                                            a higher score before moving on.</p>
                                    <?php else: ?>
                                        <p class="textpo">Good Job!.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <footer class="poseroff">
                                <p><img src="<?php echo e(asset('assets/img/Group-6.png')); ?>">Lesson completed!</p>

                                <?php if(\Carbon\Carbon::parse(auth()->user()->streak_updated)->diffInHours(Carbon::now()) >= 15): ?>
                                    <p><img src="<?php echo e(asset('assets/img/svgexport-6.png')); ?>">Streak Increased </p>
                                <?php endif; ?>
                            </footer>
                        </div><!-- fxontent -->
                        <div class="check-button-container skorn d-flex">
                            <form action="<?php echo e(route('front.dashboard.lessonquiz', $lesson->quiz->id)); ?>" method="get">
                                <button class="undo-button-containe undo" type="submit"><img
                                        src="<?php echo e(asset('assets/img/Icon-undo.png')); ?>"> Undo</button>
                            </form>


                        </div>
                    </div><!-- col-md-12 col-sm-7 col-lg-7 -->
                </div><!-- row justify-content-center -->
            </div>
        </section>







    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/easy-pie-chart/2.1.6/jquery.easypiechart.min.js" charset="utf-8">
    </script>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <script src="<?php echo e(asset('assets/mona/assets/js/vendor/vendor.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery-migrate-1.2.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/slick.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/mona/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.counterup.js')); ?>"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <script src="<?php echo e(asset('assets/mona/assets/js/jquery.slimscroll.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/mona/assets/js/jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/mona/assets/plugins/light-gallery/js/lightgallery-all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/mona/assets/js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/mona/jave/owl.carousel.min.js')); ?>"></script>

    <script type="text/javascript">
        $(function() {
            $('.chart').easyPieChart({
                size: 90,
                barColor: "#70C491E5",
                scaleLength: 0,
                lineWidth: 10,
                trackColor: "#FF7648",
                lineCap: "circle",
                animate: 2000,
            });
        });
    </script>
    <script type="text/javascript">
        $(function() {
            $('.chart1').easyPieChart({
                size: 100,
                barColor: "#70C491E5",
                scaleLength: 0,
                lineWidth: 10,
                trackColor: "#F7F7F7",
                lineCap: "circle",
                animate: 2000,
            });
        });
    </script>
</body>


</html>
<?php /**PATH /home/active4web/public_html/candly/resources/views/Front/dashboard/pages/result-1.blade.php ENDPATH**/ ?>