@extends('Front.layouts.master')

@section('title', config('app.name') . ' - Home')
@section('css')
@endsection
@section('content')

    <div class="maincontent">
        <div class="main-slide">
            <div class="container">
                <div id="sync1" class="owl-carousel owl-theme">
                    @foreach ($sliders as $slider)
                        <div class="item"   >
                            <div
                                class="row justify-content-center justify-content-lg-between text-left   align-items-center">

                                <div class="col-12 col-md-10 col-lg-5 px-0">
                                    <h1>{{ $slider->title }} </h1>
                                    <p class="subtitle">{{ $slider->description }}</p>
                                    <div class="contestart">
                                        @guest
                                            <a href="{{ route('registerpage') }}" class="btn btn-info">Sign Up Now</a>
                                        @endguest
                                    </div>
                                </div>
                                <div class="col-lg-7 col-12">
                                    <div class="overimg"><img class="laz-image" src="{{ asset($slider->image) }}"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach

                </div><!-- sync1 -->
            </div>
        </div><!-- main-slide -->

        <div class="onesection mb-5">
            <div class="container">
                <div class="CounterBlock">
                    <div class="row">
                        <div class="col-12 col-md-3 col-lg-3">
                            <div class="counter-block">
                                <span class="md22i"><img src="{{ asset('assets/img/chat.png') }}"></span>
                                <div class="details">
                                    <h3 class="mb-0 mt-0 number"><em class="count">455</em><i class="fa-solid fa-plus"></i>
                                    </h3>
                                    <p class="mb-0">Online Learner</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-3 col-lg-3">
                            <div class="counter-block">
                                <span class="md22i"><img src="{{ asset('assets/img/winner.png') }}"></span>
                                <div class="details">
                                    <h3 class="mb-0 mt-0 number"><em class="count">775</em><i class="fa-solid fa-plus"></i>
                                    </h3>
                                    <p class="mb-0">Earned Certificate</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-3 col-lg-3">
                            <div class="counter-block">
                                <span class="md22i"><img src="{{ asset('assets/img/instructor.png') }}"></span>
                                <div class="details">
                                    <h3 class="mb-0 mt-0 number"><em class="count">300</em><i class="fa-solid fa-plus"></i>
                                    </h3>
                                    <p class="mb-0">skilled instructors</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-3 col-lg-3">
                            <div class="counter-block">
                                <span class="md22i"><img src="{{ asset('assets/img/student.png') }}"></span>
                                <div class="details">
                                    <h3 class="mb-0 mt-0 number"><em class="count">10</em><i class="fa-solid fa-plus"></i>
                                    </h3>
                                    <p class="mb-0">Satisfied learner</p>
                                </div>
                            </div>
                        </div>
                    </div><!--End Counter Block-->
                </div>
            </div>
        </div><!-- onesection -->

        <div class="aboutsection">
            <div class="container">
                <div class="poserr" style="padding-bottom: 0px !important;">
                    <div class="row">
                        <div class="col-md-12 col-sm-6 col-lg-6 mb-25 pr-0 pl-0"  style="padding-left: 0px !important;">
                            <div class="slitype-325"  style="padding-left: 0px;">
                                <img src="{{ asset($sections['0']->images->image) }}">
                            </div>
                        </div><!-- col-md-12 col-sm-3 col-lg-3 -->

                        <div class="col-md-12 col-sm-6 col-lg-6 mb-25 pr-0">
                            <div class="slity325">
                                <h1>{{ $sections['0']->title }}</h1>
                                <p class="subtitle">{{ $sections['0']->description }} </p>
                                <div class="contestart">
                                    <a href="{{ route('front.about') }}" class="btn btn-info">About Us</a>
                                </div>
                            </div>
                        </div><!-- "col-md-12 col-sm-6 col-lg-6 -->
                    </div><!-- row -->
                </div>
            </div>
        </div><!-- serviceoff -->

        <div class="serviceoff">
            <div class="container">
                <h3 class="tiltrong">{{ $sections['1']->title }}</h3>
                <div class="row">

                    @foreach ($sections['1']->sectionItems as $item)
                        <div class="col-md-12 col-sm-4 col-lg-4 mb-25 pr-0">
                            <div class="promo-item">
                                <div class="promo-img">
                                    <img src="{{ asset($item->icon) }}">
                                </div>
                                <h5>
                                    <a href="#">{{ $item->title }} </a>
                                </h5>
                                <p>{{ $item->description }}</p>
                            </div>

                        </div><!-- col-md-12 col-sm-4 col-lg-4 -->
                    @endforeach

                </div><!-- row -->
            </div>
        </div><!-- serviceoff -->

        @guest

            <div class="oppdive">
                <div class="container">
                    <div class="backgroundservic">
                        <div class="row">
                            <div class="col-md-12 col-sm-9 col-lg-9 pl-0 pr-0">
                                <div class="conover text-left">
                                    <h5>Ready To Join Arabic Conversation Course</h5>
                                    <p> You Can log in to your account anytime to learn by your self.</p>
                                </div>
                            </div>

                            <div class="col-md-12 col-sm-3 col-lg-3 pl-0 pr-0">
                                <div class="contoff">
                                    <a href="{{ route('registerpage') }}" class="btn btn-light">REGISTER NOW</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- backgroundservic -->

        @endguest

    @endsection


    @section('js')
    @endsection