@inject('setting', 'App\Models\Setting')

<?php $setting = $setting::first(); ?>

@extends('Front.layouts.master')

@section('title', config('app.name') . ' - Contact Us')


@section('css')
@endsection
@section('content')
    <div class="maincontent">

        <section class="page-title bg-img-center" style="background-image: url({{ asset('assets/img/Group2708.png') }});">
            <div class="container">
                <div class="breadcrumbs">
                    <h2 class="title">CONTACT US</h2>
                    <span><a href="index.html" rel="home"> Home </a></span>
                    <span><i class="fa fa-angle-left"></i></span>
                    <span>CONTACT US</span>
                </div>
            </div>
        </section>


        <section class="CONTACT-US">
            <div class="container">

                <div class="section-content">
                    <h2>CONTACT US</h2>
                    <p>See Our Contacts</p>

                    <div class="row">
                        <div class="col-sm-12 col-md-4">
                            <div class="icon-box-wrapper">
                                <div class="icon-wrapper mb-30">
                                    <i class="fas fa-envelope"></i>
                                </div>

                                <h5 class="icon-box-title mt-0">Email Us To Get Info</h5>
                                <a href="mailto:{{ $setting->email }}">{{ $setting->email }}</a>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <div class="icon-box-wrapper">
                                <div class="icon-wrapper mb-30">
                                    <i class="fas fa-phone font-icon"></i>
                                </div>
                                <h5 class="icon-box-title mt-0">Call Us To Join With Us</h5>
                                <a href="tel:{{ $setting->phone }}">{{ $setting->phone }}</a>
                            </div>
                        </div>

                        <div class="col-sm-12 col-md-4">
                            <div class="icon-box-wrapper">
                                <div class="icon-wrapper mb-30">
                                    <i class="fas fa-location fa-fw"></i>
                                </div>
                                <h5 class="icon-box-title mt-0">Our Location</h5>
                                <p class="content">{{ $setting->address }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="poserko">
                    <div class="row">
                        <div class="col-lg-7">
                            <h2 class="mt-0 mb-0">{{ $sections['0']->title }}</h2>
                            <p>{{ $sections['0']->description }}</p>

                            <form class="offerbest" method="post" action="{{ route('front.contactstore') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-6 px-1">
                                        <div class="form-group">
                                            <input type="text"
                                                class="form-control  required @error('name') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="Your Name" name="name" value="{{ old('name') }}" />
                                            @error('name')
                                                <span class="invalid-feedback text-red font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-6 px-1">
                                        <div class="form-group">
                                            <input type="email"
                                                class="form-control  @error('email') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="Your Email" name="email" value="{{ old('email') }}" />
                                            @error('email')
                                                <span class="invalid-feedback text-red font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-12 px-1">
                                        <div class="form-group">
                                            <input type="phone"
                                                class="form-control  required @error('phone') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="Your Phone" name="phone" value="{{ old('phone') }}" />
                                            @error('phone')
                                                <span class="invalid-feedback text-red font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-12 px-1">
                                        <div class="form-group">
                                            <input type="subject"
                                                class="form-control  required @error('subject') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="Your Subject" name="subject" value="{{ old('subject') }}" />
                                            @error('subject')
                                                <span class="invalid-feedback text-red font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-sm-12 px-1">
                                        <div class="form-group">
                                            <textarea class="form-control @error('message') is-invalid fparsley-error parsley-error @enderror" placeholder="Message"
                                                name="message">{{ old('message') }}</textarea>
                                            @error('message')
                                                <span class="invalid-feedback text-red font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="contestart">
                                    <button type="submit" class="btn btn-success">Send Message <i
                                            class="fa fa-angle-right"></i></button>

                                </div>
                                @if (session()->has('message'))
                                    <div class="alert alert-success">
                                        {{ session()->get('message') }}
                                    </div>
                                @endif
                            </form>
                        </div>
                        <div class="col-lg-5">
                            <div class="slitype-325">
                                <img src="{{ asset($sections['0']->images->image) }}">
                            </div>
                        </div>
                    </div>


                </div>

            </div>
        </section>
    @endsection


    @section('js')
    @endsection
