@extends('Front.dashboard.layouts.master')

@section('title', config('app.name') . '-'.$unit->course->title)

@section('css')@endsection

@section('level-2')
<a href="{{ route('front.dashboard.index', $unit->course->id) }}"> Course {{ $unit->course->title }}</a>
@endsection
@section('level-3')
    Unit {{ $unit->number }}
@endsection
@section('content')
    <section class="Dashboard px-3">
        <div class="conmona serv">
            <h1 class="overpasr"><a href="{{ route('front.dashboard.index', $unit->course->id) }}">  {{ $unit->course->title }} </a></h1>
            <div class="form-group">

                {{-- @foreach ($unit->units as $levelunit)
                    <a href="{{ route('front.dashboard.unitLesson', $unit->id) }}"> Unit {{ $levelunit->number }} </a>
                @endforeach --}}

            </div>
        </div>
        <div class="unit-content nn">
            <div class="usr-msg-details baby">
                <div class="box">
                    <?php
                    if ($unit->lessons->count()) {
                        $precent =
                            (auth()
                                ->user()
                                ->studentLessonFinshed->where('unit_id', $unit->id)
                                ->count() /
                                $unit->lessons->count()) *
                            100;
                    }
                    ?>
                    <div class="chart" data-percent="{{ $precent ?? 0 }}">
                        <img src="{{ asset(auth()->user()->image) }}"  class="rounded-circle">
                    </div>
                    <span class="contt">{{ $unit->number }}</span>
                </div>
                <div class="usr-mg-info">
                    <h3>
                        <a href="">{{ $unit->course->title }}</a>
                        {{-- <strong>
                            <i class="fa-solid fa-chevron-right"></i>
                            level {{ $unit->number }}
                        </strong> --}}
                        <strong>
                            <i class="fa-solid fa-chevron-right"></i>
                            Unit {{ $unit->number }}
                        </strong>
                    </h3>
                    <strong> Unit {{ $unit->number }}</strong>
                    <p>{{ $unit->title }}</p>
                    <div class="completions">
                        <span style="color: rgb(99, 183, 104); padding-right: 5px;">
                            {{ auth()->user()->studentLessonFinshed->where('unit_id', $unit->id)->count() }}
                        </span> / {{ $unit->lessons->count() }} Lessons Completed
                    </div>
                </div>
            </div>
            @if (session('message'))
                <div class="alert alert-secondary" role="alert">
                    {{ session('message') }}
                </div>
            @endif
            <div class="locerw">
                <div class="row unit-circle">
                    @foreach ($unit->lessons->sortBy('number') as $lessonitem)
                        <div class="col-md-3 mb-2">
                            <div class="course-cardd"  style="background: #fff;border: 1px solid #5ccb9f;">
                                <a class=" lesson-info" href="{{ route('front.dashboard.lessonFlash', $lessonitem->id) }}">
                                    <div class="movie-thumbnail">


                                        @isset($lessonitem->images->image)
                                            <img style=" width:100%" src="{{ asset($lessonitem->images->image) }}">
                                        @endisset

                                    </div>
                                    <article>
                                        <a href="{{ route('front.dashboard.lessonFlash', $lessonitem->id) }}"> Lesson
                                            {{ $lessonitem->number }}</a>
                                        <p class="truncate-overflow"  style="padding:10px 3px 0px; font-size:13px;">{{ $lessonitem->title }}</p>
                                        <div class="rating ratinglesson" >
                                            @for ($i = 0; $i < 5; $i++)
                                                @if ($i < $lessonitem->lessonReviews->average('rate'))
                                                    <span class="fas fa-star fa-fw"></span>
                                                @endif
                                            @endfor
                                        </div>
                                    </article>


                                    @if (auth()->user()->studentLessonFinshed->where('lesson_id', $lessonitem->id)->first())
                                        <div class="klopsot"><img src="{{ asset('assets/img/Group-6.png') }}"
                                                class="perfect-score"></div>
                                    @else
                                        <div class="icon-backround-check"
                                            style="left: 0px;
                                                height: 40px;
                                                width: 40px;
                                                background-color: #fff;
                                                margin: 0 auto;">

                                            <svg aria-hidden="true" focusable="false" data-prefix="fas"
                                                data-icon="check-circle" class="svg-inline--fa fa-check-circle fa-w-16 "
                                                role="img"
                                                xmlns="http://www.w3.org/2000/svg"style="color: rgb(218, 219, 213);"
                                                viewBox="0 0 512 512">
                                                <path fill="currentColor"
                                                    d="M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z">
                                                </path>
                                            </svg>

                                        </div>
                                    @endif
                                </a>
                            </div>
                        </div>
                    @endforeach
                    </div>
            </div>
        </div><!-- unit-content -->



    </section><!-- postspagrt -->
@endsection

@section('js')
@endsection
