@extends('Front.dashboard.layouts.master')

@section('title')
    Profile-setting
@endsection

@section('css')
@endsection

@section('content')
    <section class="flashcardff">
        <div class="conmona">
            <i class="fa-solid fa-chevron-left"></i>
            <h1 class="overpasr">Profile Setting</h1>
        </div>
        @if (Session::has('error'))
            <div class="alert alert-danger">
                {{ Session::get('error') }}
            </div>
        @endif
        @if (Session::has('success'))
            <div class="alert alert-success">
                {{ Session::get('success') }}
            </div>
        @endif
        <div class="row justify-content-center">
            <div class="col-md-12 col-sm-4 col-lg-4 px-1">
                <div class="cardmasterq">
                    <div class="cardbody">
                        {{-- <div class="imgtex1">

                            @isset(auth()->user()->image)
                                <img src="{{ asset(auth()->user()->image) }}">
                            @endisset
                            <h5>{{ auth()->user()->name }}</h5>
                        </div> --}}

                        <!-- <ul class="listoff">
                                                              <li><span></span><h5>Course in progress</h5></li>
                                                              <li><span>23</span><h5>Course Complere</h5></li>
                                                            </ul> -->
                        <div class="listtwoo">
                            @include('Front.dashboard.pages.inc.profile-sidebar')

                        </div>



                    </div><!-- card-body -->
                </div><!-- card masterq -->
            </div><!-- col-md-12 col-sm-4 col-lg-4 px-1-->
            <div class="col-md-12 col-sm-8 col-lg-8 px-1">
                <div class="camasterq">
                    <div class="carbody">
                        <div class="imtext">

                            @if (\Session::has('message'))
                                <div class="alert alert-success">
                                    <ul>
                                        <li>{!! \Session::get('message') !!}</li>
                                    </ul>
                                </div>
                            @endif

                            <h2>Profile Setting</h2>
                            <p>Personal Details</p>
                        </div>
                        <form action="{{ route('front.dashboard.profileupdate') }}" method="post"
                            enctype="multipart/form-data">
                            @csrf
                            @method ('put')
                            <input type="hidden" name="id" value="{{ $user->id }}">

                            <div class="form-row">
                                <div class="col mb-3">
                                    <label class="mb-2"> Name </label>
                                    <input type="text"
                                        class="form-control @error('name') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Last name" name="name"
                                        value="{{ old('name', $user->name ?? '') }}" />
                                    @error('name')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col mb-3">
                                    <label class="mb-2"> Email </label>
                                    <input type="email"
                                        class="form-control @error('email') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Email" name="email"
                                        value="{{ old('email', $user->email ?? '') }}" />
                                    @error('email')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col mb-3">
                                    <label class="mb-2"> Daily goal lesson</label>
                                    <input type="number"
                                        class="form-control @error('daily_goal_lesson') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="daily_goal_lesson" name="daily_goal_lesson"
                                        value="{{ old('daily_goal_lesson', $user->daily_goal_lesson ?? '') }}" />
                                    @error('daily_goal_lesson')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col mb-3">
                                    <label class="mb-2"> Daily goal medal</label>
                                    <input type="number"
                                        class="form-control @error('daily_goal_medal') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="daily_goal_medal" name="daily_goal_medal"
                                        value="{{ old('daily_goal_medal', $user->daily_goal_medal ?? '') }}" />
                                    @error('daily_goal_medal')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col mb-3">
                                    <label class="mb-2"> Image </label>
                                    <input type="file"
                                        class="form-control @error('image') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="choose image" name="image"
                                        value="{{ old('image', $user->image ?? '') }}" />
                                    @error('image')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>


                                <div class="col mb-3">
                                    <label class="switch"class="mb-2"> Send notifications</label>
                                    <input type="checkbox" class="m-2" name="send_notifications" value="1"
                                        {{ auth()->user()->send_notification == 1 ? 'checked' : '' }} />
                                    <span class="slider round"></span> @error('send_notification')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                            </div>



                            <div class="buttonl">
                                <button type="submit" class="btn btn-primary">Save profile</button>
                            </div>
                        </form>

                        <div class="form-row">
                            <div class="col m-3">
                                <h1>
                                    Streak: <span>{{ auth()->user()->streak }} </span>
                                </h1>

                            </div>
                            <div class="col m-3">
                                <h1>
                                    Best Streak: <span>{{ auth()->user()->best_streak }} </span>
                                </h1>

                            </div>
                        </div>

                    </div><!-- card-body -->
                </div><!-- card masterq -->
            </div><!-- col-md-12 col-sm-4 col-lg-4 px-1-->
        </div><!-- row -->
    </section><!-- postspagrt -->
@endsection

@section('js')
@endsection
