@extends('Front.dashboard.layouts.master')

@section('title')
    flashcard-mastery
@endsection

@section('css')
@endsection

@section('content')
    <section class="flashcardff">
        <div class="conmona">
            <a href="{{ URL::previous() }}"> <i class="fa-solid fa-chevron-left"></i></a>
            <h1 class="overpasr">{{ $course->title }}</h1>
        </div>
        <div class="row justify-content-center">
            @foreach ($course->units as $unit)
                @if ($unit->FlashCard !== 0)
                    <div class="col-md-4 col-sm-4 col-lg-6 px-1">
                        <div class="row justify-content-center">
                            <a href="{{ route('front.dashboard.masteryflashcardcollection', $unit->id) }}">
                                <div class="col-md-12 col-sm-4 col-lg-6 px-1">
                                    <div class="card chart25">
                                        <div class="card-body">
                                            <div class="box">
                                                <div class="chart1"
                                                    data-percent="{{ ($unit->MasteryFlashCard / $unit->FlashCard) * 100 }}">
                                                    {{ round(($unit->MasteryFlashCard / $unit->FlashCard) * 100) }} %</div>
                                            </div><!-- box -->
                                            <h2>Level {{ $unit->number }}</h2>
                                            <p>
                                                <img src="{{ asset('assets/img/svgexport-24.png') }}">
                                                <span class="numbers">
                                                    <span
                                                        class="mastered-number in-progress">{{ $unit->MasteryFlashCard }}</span>

                                                    <span class="total-number">/{{ $unit->FlashCard }}</span>
                                                </span>
                                            </p>
                                        </div><!-- card-body -->
                                    </div><!-- card chart25 -->
                                </div><!-- col-md-12 col-sm-4 col-lg-4 px-1-->
                            </a>
                        </div>
                    </div>
                @endif
            @endforeach

        </div><!-- row -->
    </section><!-- postspagrt -->
@endsection

@section('js')
@endsection
