@extends('Front.dashboard.layouts.master')

@section('title')
  Blog
@endsection
@section('level-2')
  Blog
@endsection

@section('css')
@endsection

@section('content')
  <div class="BlogListPage mb-5">
    <div class="row justify-content-center mb-5">
      <div class="col-md-12 col-sm-7 col-lg-7 px-0">
        <section class="postspagrt">
          <h1 class="overpasr">Official Blog</h1>
          @foreach($blogs as $blog)
            <div class="BlogListItem">
              <div class="image">
                <a href="{{route('front.dashboard.singleBlog',$blog->id)}}">
                  <img src="{{asset($blog->image)}}">
                </a>
              </div>
              <div class="details">
                <div class="author">
                  <img src="{{asset('assets/img/author.png')}}">
                  <span>{{$blog->by}} | {{$blog->created_at}}</span>
                </div>
                <a href="{{route('front.dashboard.singleBlog',$blog->id)}}">
                  <h2>{{$blog->title}}</h2>
                </a>
                <p>{{Str::words($blog->description,20)}}</p>
                <a class="list-nav" href="{{route('front.dashboard.singleBlog',$blog->id)}}">Read More</a>

              </div>
            </div><!-- BlogListItem -->
          @endforeach

        </section><!-- postspagrt -->
      </div><!-- col-md-12 col-sm-7 col-lg-7 px-0 -->
    </div><!-- row -->
  </div><!-- BlogListPage -->

@endsection

@section('js')
@endsection
