@extends('Front.dashboard.layouts.master')

@section('title', config('app.name') . ' - dashboard')

@section('level-2')
    Course ({{ $course->title ?? 'Welcome' }})
@endsection


@section('css')
    <style>
        .course-img {
            width: 50px;
            height: 50px;
        }
    </style>
@endsection

@section('content')
    <section class="Dashboard ">

        <div class="conmona serv mb-5"  >
            <h1 class="overpasr">{{ $course->title ?? 'Welcome' }}</h1>
        </div>
  
        <div class="row justify-content-center mb-5">
            <div class="col-md-12 col-sm-3 col-lg-3 px-1">

                <ul class="disable-scrollbars">
                    @foreach ($courses as $ncourse)
                        <li>
                            <a class="loveerrpo" href="{{ route('front.dashboard.index', $ncourse->id) }}"
                                style="background: {{ $ncourse->background_color }};">
                                <h6>{{ $ncourse->title }}</h6>
                                <img src="{{ asset($ncourse->icon) }}" class="course-img">
                            </a>
                        </li>
                    @endforeach


                </ul>
            </div><!-- col-md-12 col-sm-4 col-lg-4 px-1-->
            <div class="col-md-12 col-sm-9 col-lg-9 px-1">
                <div class="cacart25">
                    <div class="steps kolbutton">
                        @if (session('error'))
                            <div class="alert alert-danger" role="alert">
                                {{ session('error') }}
                            </div>
                        @elseif(session('success'))
                            <div class="alert alert-success" role="alert">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (isset($course))
                            @if (count($course->units) >= 1)
                                <div class="row">
                                    @foreach ($course->units as $unit)
                                        <div class="col-md-3 col-sm-3 col-lg-3 px-1">
                                            <a href="{{ route('front.dashboard.unitLesson', $unit->id) }}">
                                                <div class="card LugrLyI">
                                                    <div class="card-body">
                                                        <div class="deceader">
                                                            <img src="{{ asset($unit->icon) }}">
                                                        </div>
                                                        <div class="staline">
                                                            <h3>Unit {{ $unit->number }} </h3>

                                                            @if (auth()->user()->studentLessonsUnFinshed->where('unit_id', $unit->id)->count() == 0)
                                                                <p> {{ $unit->title }}</p>
                                                                <div class="wizard-progress">
                                                                    <div class="progress">
                                                                        <div class="progress-bar" style="width:0%;">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @elseif(auth()->user()->studentLessonsUnFinshed->where('unit_id', $unit->id)->count() == $unit->lessons->count())
                                                                <p> {{ $unit->title }} </p>

                                                                <div class="wizard-progress">
                                                                    <div class="progress">
                                                                        <div class="progress-bar" style="width:70%;">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @elseif(auth()->user()->studentLessonFinshed->where('unit_id', $unit->id)->count() == $unit->lessons->count())
                                                                <p> {{ $unit->title }}</p>
                                                                <span class="toer">Completed</span>
                                                            @elseif(auth()->user()->studentLessons->where('unit_id', $unit->id)->count() == $unit->lessons->count())
                                                                <p> {{ $unit->title }}</p>

                                                                <div class="wizard-progress">
                                                                    <div class="progress">
                                                                        <div class="progress-bar" style="width:70%;">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @else
                                                                <p> {{ $unit->title }}</p>
                                                                <div class="wizard-progress">
                                                                    <div class="progress">
                                                                        <div class="progress-bar" style="width:0%;">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    @endforeach
                                </div>
                    </div>
                @else
                    <p>
                        No Units Added yet.
                    </p>
                    @endif
                @else
                <h1 class="overpasr" style="text-align:center;color:#7DC99B">Please select a course.</h1>
                  
                    @endif
                </div>
            </div>
        </div>
        </div><!-- col-md-12 col-sm-8 col-lg-8 px-1-->

        </div><!-- row -->
    </section><!-- postspagrt -->
@endsection

@section('js')
@endsection
