@extends('Front.layouts.master')

@section('title')
    Verify Your Email
@endsection
@section('css')
@endsection
@section('content')
    <div class="loginsection">
        <div class="container">
            <div class="row">
                <div class="container">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if (Session::has('success'))
                        <div class="alert alert-success">
                            {{ Session::get('success') }}
                        </div>
                    @endif
                    <form action="{{ route('verify-account') }}" method="post">
                        @csrf

                        <div class="form-group">
                            <input name= "code" type="text"
                                class="form-control form-control-user @error('code') is-invalid fparsley-error parsley-error @enderror"
                                id="" aria-describedby="textHelp" placeholder="Enter your Code...">
                        </div>
                        @error('code')
                            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                        @enderror
                        <button class="btn btn-warning" type="submit"> submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('js')
@endsection
