@extends('Admin.layouts.master')

@section('title')
    Create SectionItem
@endsection
@section('page_title', 'Create SectionItem')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Create Section Item</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.sub.sectionitem.store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <div class="form-group mb-8">

                                <div class="form-group">
                                    <label>Title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Title" name="title"
                                        value="{{ old('title', $sectionitem->title ?? '') }}" />
                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="exampleTextarea">Description</label>
                                    <textarea class="form-control @error('description') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Description" name="description">{{ old('description', $sectionitem->description ?? '') }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>icon
                                        <span class="text-danger">*</span></label>
                                    <input type="file"
                                        class="form-control @error('icon') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="icon" name="icon"
                                        value="{{ old('icon', $sectionitem->icon ?? '') }}" />
                                    @error('icon')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>Icon-Color
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('icon_color') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="icon_color" name="icon_color"
                                        value="{{ old('icon_color', $sectionitem->icon_color ?? '') }}" />
                                    @error('icon_color')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>Icon-Background-Color
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('icon_background_color') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="icon_background_color" name="icon_background_color"
                                        value="{{ old('icon_background_color', $sectionitem->icon_background_color ?? '') }}" />
                                    @error('icon_background_color')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>





                                <div class="form-group">
                                    <label for="exampleSelect1">sections
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('section_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="section_id">
                                        <option value="">choose sections</option>
                                        @foreach ($sections as $section)
                                            <option value="{{ $section->id }}"
                                                {{ old('section_id') == $section->id ? 'selected' : '' }}>
                                                {{ $section->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('section_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>

@endsection


@section('js')


@endsection
