@extends('Admin.layouts.master')

@section('title')
    Create Section
@endsection
@section('level-2')
    <a href="{{route('admin.sub.section.index')}}">Sections</a>
@endsection
@section('level-3')
    Create
@endsection
@section('page_title', 'Create Section')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Create Section</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.sub.section.store') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <div class="form-group mb-8">

                                <div class="form-group">
                                    <label>Title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Title" name="title"
                                        value="{{ old('title', $section->title ?? '') }}" />
                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="exampleSelect1">Pages
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('page_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="page_id">
                                        <option value="">choose pages</option>
                                        @foreach ($pages as $page)
                                            <option value="{{ $page->id }}"
                                                {{ old('page_id') == $page->id ? 'selected' : '' }}> {{ $page->title }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('page_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-5">
                                    <label>image
                                        <span class="text-danger">*</span>
                                    </label>
                                    <input type="file"
                                        class="form-control @error('image') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="image" name="image"
                                        value="{{ old('image', $section->image ?? '') }} " />
                                    @error('image')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="exampleTextarea">Descrption</label>
                                    <textarea id="kt-ckeditor-1"
                                        class="form-control ckeditor @error('description') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="description" name="description">{{ old('description', $section->description ?? '') }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>

@endsection


@section('js')
    <script src="{{ asset('assets/Admin/assets/plugins/custom/ckeditor/ckeditor-classic.bundle.js') }}"></script>
    <script src="{{ asset('assets/Admin/assets/js/pages/crud/forms/editors/ckeditor-classic.js') }}"></script>
@endsection
