@extends('Admin.layouts.master')

@section('title')
    Edit Student
@endsection
@section('level-2')
    <a href="{{route('admin.student.index')}}">Students</a>
@endsection
@section('level-3')
    Edit
@endsection
@section('page_title', 'Edit Student')

@section('css')
@endsection

@section('content')
    <!--begin::Container-->
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit Student</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.student.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('put')
                        <div class="card-body">
                            @include('Admin.student._form')
                            <input type="hidden" name="id" value="{{ $student->id }}">
                            <div class="checkbox-inline">
                                <label class="checkbox checkbox-success">
                                    <input type="checkbox" name="Checkbox"
                                        {{ $student->is_active == 1 ? 'checked' : '' }} />
                                    <span></span>
                                    deactive Account
                                </label>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>

                        </div>
                    </form>
                    <!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>
    <!--end::Container-->

@endsection


@section('js')


@endsection
