@extends('Admin.layouts.master')

@section('title')
    Edit Slider
@endsection
@section('level-2')
    <a href="{{ route('admin.slider.index') }}">Slider</a>
@endsection
@section('level-3')
    Edit
@endsection
@section('page_title', 'Edit Slider')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit Slider</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.slider.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('PUT')
                        <input type="hidden" name="id" value=" {{ $slider->id }}">
                        <input type="hidden" name="page_id" value=" {{ $slider->page_id }}">
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <div class="form-group col-5">
                                    <label>Image
                                        <span class="text-danger">*</span></label>
                                    <input type="file"
                                        class="form-control @error('image') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="image" name="image"
                                        value="{{ old('image', $slider->image ?? '') }} " />
                                    @error('image')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>Title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Title" name="title"
                                        value="{{ old('title', $slider->title ?? '') }}" />
                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>


                                <div class="form-group">
                                    <label for="exampleTextarea">Descrption</label>
                                    <textarea class="form-control @error('description') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Description" name="description">{{ old('description', $slider->description ?? '') }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
