@extends('Admin.layouts.master')

@section('title')
    Edit Section
@endsection
@section('level-2')
    <a href="{{route('admin.section.index')}}">Pages</a>
@endsection
@section('level-3')
    Edit
@endsection
@section('page_title', 'Edit Section')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit Section</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.section.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('put')
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <input type="hidden" name="id" value="{{ $section->id }}">
                                <div class="form-group">

                                    <label>Title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Title" name="title" value="{{ old('title', $section->title) }}" />
                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="exampleSelect1">Pages
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('page_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="page_id">
                                        <option value="">choose pages</option>
                                        @foreach ($pages as $page)
                                            <option value="{{ $page->id }}"
                                                {{ old('page_id') == $page->id || (isset($section->page_id) && $page->id == $section->page_id) ? 'selected' : '' }}>
                                                {{ $page->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('page_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="exampleTextarea">Descrption</label>
                                    <textarea class="form-control @error('description') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Description" name="description">{{ old('description', $section->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group col-5">
                                    <label>image
                                        <span class="text-danger">*</span>
                                    </label>
                                    <input type="file"
                                        class="form-control @error('image') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="image" name="image"
                                        value="{{ old('image', $section->image ?? '') }} " />
                                    @error('image')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
