@extends('Admin.layouts.master')

@section('title')
    Edit Lesson
@endsection

@section('level-2')
    <a href="{{route('admin.lessonfaq.index')}}">Lesson Faq</a>
@endsection
@section('level-3')
    Edit
@endsection

@section('page_title', 'Edit Lesson')

@section('css')
@endsection

@section('content')
    <!--begin::Container-->
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit Lesson</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.lessonfaq.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('put')

                        <div class="card-body">
                            <div class="form-group mb-8">


                                <div class="form-group">
                                    <label>answer
                                        <span class="text-danger">*</span></label>
                                    <textarea type="text" class="form-control @error('answer') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="answer" name="answer">{{ old('answer', $lessonfaq->answer ?? '') }}</textarea>
                                    @error('answer')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                            </div>
                        </div>
                        <input type="hidden" name="id" value="{{ $lessonfaq->id }}">
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>

                        </div>
                    </form>
                    <!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>
    <!--end::Container-->

@endsection


@section('js')


@endsection
