@extends('Admin.layouts.master')

@section('title')
    Edit guide detail
@endsection
@section('level-2')
    <a href="{{route('admin.guidedetail.index')}}">guides detail</a>
@endsection
@section('level-3')
Edit
@endsection
@section('title', 'Edit guide detail')

@section('css')


@endsection

@section('content')

    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit guide detail</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.guidedetail.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('put')
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <input type="hidden" name="id" value="{{ $guidedetail->id }}">
                                <div class="form-group">
                                    <label for="exampleSelect1">guide
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('guide_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="guide_id">
                                        <option value="">choose guide</option>
                                        @foreach ($guides as $guide)
                                            <option value="{{ $guide->id }}"
                                                {{ old('guide_id') == $guide->id || $guide->id == $guidedetail->guide_id ? 'selected' : '' }}>
                                                {{ $guide->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('guide__id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>Title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Title" name="title"
                                        value="{{ old('title', $guidedetail->title ?? ' ') }}" />
                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="exampleTextarea">description</label>
                                    <textarea type="text"class="form-control @error('description') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="description" name="description">
                 {{ $guidedetail->description }} </textarea>
                                    @error('description')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>link
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('link') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="link" name="link"
                                        value="{{ old('link', $guidedetail->link ?? ' ') }}" />
                                    @error('link')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>image
                                        <span class="text-danger">*</span></label>
                                    <input type="file"
                                        class="form-control @error('image') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="image" name="image" value="{{ old('image') }}" />
                                    @error('image')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
