@extends('Admin.layouts.master')

@section('title')
    Edit download attachement
@endsection
@section('level-2')
    <a href="{{route('admin.downloadattachement.index')}}">Download attachement</a>
@endsection
@section('level-3')
    Edit
@endsection
@section('title', 'Edit download attachement')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit download attachement</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.downloadattachement.update') }}"
                        enctype="multipart/form-data">
                        @csrf
                        @method ('put')

                        <input type="hidden" name="id" value="{{ $downloadattachement->id }}">
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <div class="form-group">
                                    <label for="exampleSelect1">download
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('download_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="download_id">
                                        <option value="">choose download</option>
                                        @foreach ($downloads as $download)
                                            <option value="{{ $download->id }}"
                                                {{ old('download_id') == $download->id || $download->id == $downloadattachement->download_id ? 'selected' : '' }}>
                                                {{ $download->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('download_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>Title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Title" name="title"
                                        value="{{ old('title', $download->title ?? '') }}" />
                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>


                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
