@extends('Admin.layouts.master')

@section('title')
    Edit coursegoal
@endsection
@section('level-2')
    <a href="{{route('admin.coursegoal.index')}}">Course goal</a>
@endsection
@section('level-3')
    Edit
@endsection
@section('page_title', 'Edit coursegoal')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit coursegoal</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.coursegoal.update') }}">
                        @csrf
                        @method ('put')
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <input type="hidden" name="id" value="{{ $coursegoal->id }}">
                                <div class="form-group">

                                    <label>Goal
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('goal') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="goal" name="goal"
                                        value="{{ old('goal', $coursegoal->goal ?? '') }}" />
                                    @error('goal')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="exampleSelect1">Courses
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('course_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="course_id">
                                        <option value="">choose course</option>
                                        @foreach ($courses as $course)
                                            <option value="{{ $course->id }}"
                                                {{ old('course_id') == $course->id || (isset($coursegoal->course_id) && $course->id == $coursegoal->course->id) ? 'selected' : '' }}>
                                                {{ $course->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('course_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
