@extends('Admin.layouts.master')

@section('title')
    Create lesson
@endsection

@section('level-2')
    <a href="{{ route('admin.course.index') }}">Courses ({{ $getUnit->course->title }})</a>
@section('level-4')
    <a href="{{ route('admin.course.unit.index', $getUnit->course_id) }}">Units ({{ $getUnit->number }})</a>
@section('level-5')
    <a href="{{ route('admin.course.lesson.index', $getUnit->id) }}">Lessons</a>
@section('level-6')
    Create
@endsection
@endsection
@endsection
@endsection


@section('page_title', 'Create lesson')

@section('css')


@endsection

@section('content')
<!--begin::Container-->
<div class="container">
<div class="row">
<div class="col-md-12">
    <!--begin::Card-->
    <div class="card card-custom gutter-b example example-compact">
        <div class="card-header">
            <h3 class="card-title">
                Create Lesson
                <i class="fa fa-chevron-right mr-2 ml-2"></i>
                belongs to Unit ({{ $getUnit->number }})
            </h3>
            <div class="card-toolbar">
                <div class="example-tools justify-content-center">

                </div>
            </div>
        </div>
        <!--begin::Form-->
        <form method="post" action="{{ route('admin.course.lesson.store', $getUnit->id) }}"
            enctype="multipart/form-data">
            @csrf
            @include('Admin.lesson._form')
            <div class="card-footer">
                <button type="submit" class="btn btn-primary mr-2">Submit</button>

            </div>
        </form>
        <!--end::Form-->
    </div>


    <!--end::Card-->
</div>
</div>
</div>
<!--end::Container-->

@endsection

@section('js')
<script src="{{ asset('assets/Admin/assets/plugins/custom/ckeditor/ckeditor-classic.bundle.js') }}"></script>
<script src="{{ asset('assets/Admin/assets/js/pages/crud/forms/editors/ckeditor-classic.js') }}"></script>
@endsection
