@extends('Admin.layouts.master')

@section('title')
    Edit country
@endsection
@section('level-2')
    <a href="{{route('admin.country.index')}}">Country</a>
@endsection
@section('level-3')
    Edit
@endsection
@section('page_title', 'Edit country')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit country</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.country.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('PUT')
                        <input type="hidden" name="id" value=" {{ $country->id }}">
                        <div class="card-body">
                            <div class="form-group">
                                <label for="exampleTextarea">Country </label>
                                <input
                                    class="form-control @error('country') is-invalid fparsley-error parsley-error @enderror"
                                    placeholder="country" name="country"
                                    value="{{ old('country', $country->country ?? '') }}">
                                @error('country')
                                    <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                        role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>

                        </div>
                    </form><!--end::Form-->
                </div>
            </div>


            <!--end::Card-->
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
