@extends('Admin.layouts.master')

@section('title')
 Contacts

@endsection
@section('level-2')
    Contacts
@endsection
@section('page_title', 'Contacts')
@section('css')

<!--begin::Page Vendors Styles(used by this page)-->
<link href="{{asset('assets/Admin/assets/plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
		<!--end::Page Vendors Styles-->
@endsection

@section('content')
<div class="d-flex flex-column-fluid">
	<div class="container">

    <div class="card card-custom gutter-b">
      <div class="card-header flex-wrap border-0 pt-6 pb-0">
        <div class="card-title">
          <h3 class="card-label">Contacts
        </div>
        <div class="card-toolbar">

        </div>
      </div>
      <div class="card-body">
        <table id="example" class="table table-separate table-head-custom table-checkable" >
          <thead>
            <tr>
              <th>#</th>
              <th>Name</th>
              <th>Email</th>
              <th>Phone</th>
              <th>Subject</th>
              <th>Message</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            @foreach($contacts as  $key=>$contact)
              <tr>
                <td>{{++ $key}}</td>
                <td> {{$contact->name}} </td>
                <td> {{$contact->email}} </td>
                <td> {{$contact->phone}} </td>
                <td> {{$contact->subject}}</td>
                <td> {{$contact->message}} </td>
                <td>
                @if (auth()->guard('admin')->user()->hasPermission('delete'))
                  <a class="btn btn-sm btn-clean btn-icon delete_form" title="Delete" data-original-title="delete" data-name="contact"   data-id="{{ $contact->id }}">
                    <span class="svg-icon svg-icon-md">
                      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                          <rect x="0" y="0" width="24" height="24"/>
                          <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" fill="#000000" fill-rule="nonzero"/>
                          <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" fill="#000000" opacity="0.3"/>
                        </g>
                      </svg>
                    </span>
                  </a>
                  @endif
                </td>
              </tr>
            @endforeach
          </tbody>
        </table><!--end: Datatable-->
      </div>
    </div><!--end::Card-->

  </div><!--end::Container-->
</div><!--end::Entry-->


@endsection


@section('js')

<!--begin::page Vendors(used by this page)-->
<script src="{{asset('assets/Admin/assets/plugins/custom/datatables/datatables.bundle.js')}}"></script>
		<!--end::Page Vendors-->
		<!--begin::Page Scripts(used by this page)-->
		<script src="{{asset('assets/Admin/assets/js/pages/crud/datatables/basic/scrollable.js')}}"></script>
		<!--end::Page Scripts-->

		<script src="{{asset('assets/Admin/assets/custom/shared.js')}}"></script>
@endsection




