@extends('Admin.layouts.master')

@section('title')
 Create Blog
@endsection
@section('level-2')
    <a href="{{route('admin.blog.index')}}">Blogs</a>
@endsection
@section('level-3')
    Create
@endsection
@section('page_title', 'Create Blog')

@section('css')


@endsection

@section('content')



  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <!--begin::Card-->
        <div class="card card-custom gutter-b example example-compact">
          <div class="card-header">
            <h3 class="card-title">Create Blog</h3>
            <div class="card-toolbar">
              <div class="example-tools justify-content-center">

              </div>
            </div>
          </div>
          <!--begin::Form-->
          <form method="post" action="{{route('admin.blog.store')}}" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
            <div class="form-group mb-8">
              <div class="form-group">

                <label>Title
                <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror" placeholder="Title"  name="title" value="{{old('by',$blog->title ?? '')}}"/>
                @error('title')
                  <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                  </span>
                @enderror
							</div>
              <div class="form-group">

                <label>Sub_title
                <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('sub_title') is-invalid fparsley-error parsley-error @enderror" placeholder="sub_title"  name="sub_title" value="{{old('sub_title',$blog->sub_title ?? '')}}"/>
                @error('sub_title')
                  <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                  </span>
                @enderror
							</div>
              <div class="form-group">
                <label for="exampleTextarea">Descrption</label>
                <textarea class="form-control @error('description') is-invalid fparsley-error parsley-error @enderror" placeholder="Description"  name="description" >{{old('description',$blog->description ?? '')}}</textarea>
                @error('description')
                  <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                  </span>
                @enderror
              </div>
              <div class="form-group">

                <label>Image
                <span class="text-danger">*</span></label>
                <input type="file" class="form-control @error('image') is-invalid fparsley-error parsley-error @enderror" placeholder="image"  name="image" value="{{old('image',$blog->image ?? '')}}"/>
                @error('image')
                  <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                  </span>
                @enderror
							</div>
              <div class="form-group">

                <label>By
                <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('by') is-invalid fparsley-error parsley-error @enderror" placeholder="by"  name="by" value="{{old('by',$blog->by ?? '')}}"/>
                @error('by')
                  <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                  </span>
                @enderror
							</div>

	          </div>

              <div class="card-footer">
                <button type="submit" class="btn btn-primary mr-2">Submit</button>

              </div>
            </div>
          </form><!--end::Form-->
        </div>


        <!--end::Card-->
      </div>
    </div>
  </div>

@endsection


@section('js')


@endsection
