@extends('Admin.layouts.master')

@section('title')
    admins
@endsection
@section('page_title', 'admins')
@section('css')

    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{ asset('assets/Admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
@section('content')

    <!--begin::Container-->
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Change Role</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form action="{{ route('admin.admin.changerole', $admin->id) }}" method="post"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="card-body">

                            <div class="form-group mb-8">



                                <div class="form-group">
                                    <label for="exampleSelect1">Role
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('roles') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="roles[]">
                                        <option value="">choose role</option>
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->id }}"
                                                @foreach ($admin->roles as $adminrole)@if ($role->id == $adminrole->id)selected @endif @endforeach>
                                                {{ $role->name }}</option>
                                        @endforeach
                                    </select>


                                </div>
                            </div>


                            <div class="card-footer">

                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Save changes</button>
                            </div>
                        </div>
                    </form>
                    <!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>
    <!--end::Container-->


@endsection


@section('js')

    <!--begin::Page Vendors(used by this page)-->
    <script src="{{ asset('assets/Admin/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <!--end::Page Vendors-->
    <!--begin::Page Scripts(used by this page)-->
    <script src="{{ asset('assets/Admin/assets/js/pages/crud/datatables/basic/scrollable.js') }}"></script>
    <!--end::Page Scripts-->

    <script src="{{ asset('assets/Admin/assets/custom/shared.js') }}"></script>
@endsection
