<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('google_id')->nullable();
            $table->string('facebook_id')->nullable();
            $table->integer('is_active')->default(0);
            $table->integer('send_notification')->default(0);
            $table->dateTime('lastseen')->nullable();
            $table->integer('streak')->default(0);
            $table->date('streak_updated')->nullable()->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->integer('total_medal')->default(0);
            $table->tinyInteger('daily_goal_lesson')->default(1);
            $table->tinyInteger('daily_goal_medal')->default(1);
            $table->integer('best_streak')->default(0);
            $table->string('image')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
