$(document).ready(function () {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $('.delete_form').click(function (event) {
        var id = $(this).data('id');
        var name =  $(this).data('name');

        Swal.fire({
            title: `Are you sure you want to delete ?`,
            text: "If you delete this, it will be gone forever.",
            icon: '',
            padding: '3em',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'yes!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `${name}/destroy/${id}`,
                    type: 'DELETE',
                    data: {
                        id: id
                    },
                    success: function (res) {
                        if (res == 1) {
                            Swal.fire(
                                'Deleted!',
                                `${name}  Has Been deleted !`,
                                'success'
                            ).then(() => {
                                location.reload();
                            })
                        } else {
                            Swal.fire(
                                'Error!',
                                `Error : ${res} !`,
                                'error'
                            )
                        }
                    }, error: function (resp) {
                        Swal.fire(
                            'Error!',
                            `Look At Your Console There is An Error !`,
                            'error'
                        )
                        console.log(resp);
                    }
                });
            }
        });
    });
});
