<?php

namespace App\Observers;

use App\Models\Subscribe;
use App\Models\CourseStudent;

class SubscribeObserver
{
    public function updating(Subscribe $subscribe): void
    {
       
        if ($subscribe->isDirty('status') && $subscribe->status == 1) {
            foreach ($subscribe->package->courses as $course) {
              
                foreach ($course->units as $level) {
                    CourseStudent::updateOrCreate([
                        'course_id' => $level->course_id,
                        'unit_id' => $level->id,
                        'user_id' => $subscribe->user_id,
                    ], [
                        'enroll_date' => $subscribe->created_at,
                    ]);
                }
            }
        }
    }
}
