<?php

namespace App\Models;

use Carbon\Carbon;
use App\Models\Setting;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;


class User extends Authenticatable  implements MustVerifyEmail

{

    use HasApiTokens, HasFactory, Notifiable;
    use \Staudenmeir\EloquentHasManyDeep\HasRelationships;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'send_notification',
        'image',
        'is_active',
        'google_id',
        'facebook_id',
        'country_id',
        'streak_updated',
        'streak',
        'daily_goal_lesson',
        'daily_goal_medal',
        'best_streak',
        'remember_token',
        'email_verified_at',
        'otp_code',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',

    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getImageAttribute($value)
    {
        return $value ? $value : Setting::first(['logo'])->logo;
    }

    public function  studentLessonFinshed()
    {
        return $this->hasMany(LessonStudent::class, 'user_id')->where('status', 1);
    }

    public function  studentLessonsUnFinshed()
    {
        return $this->hasMany(LessonStudent::class, 'user_id')->where('status', 0);
    }

    public function subscribes()
    {
        return $this->belongsToMany(Subscribe::class);
    }

    public function studentLessons()
    {
        return $this->hasMany(LessonStudent::class, 'user_id');
    }


    public function dailyCompletedLessons()
    {
        return $this->hasMany(LessonStudent::class, 'user_id')
            ->whereDate('end_date', Carbon::today()->toDateString())
            ->where('status', 1);
    }

    public function  studentCourses()
    {
        return $this->hasMany(CourseStudent::class, 'user_id');
    }

    public function studentQuizes()
    {
        return $this->hasMany(QuizStudent::class, 'user_id');
    }
    public function studentQuizesMedal()
    {
        return $this->hasMany(QuizStudent::class, 'user_id')->where('medal', 1);
    }
    public function dailystudentQuizesMedal()
    {
        return $this->hasMany(QuizStudent::class, 'user_id')->whereDate('updated_at', Carbon::today()->toDateString())->where('medal', 1);
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function userMateryFlashCard()
    {
        return $this->hasMany(UserMasterFlashCard::class, 'user_id')->where('due', '>', '5');
    }

    public function userMateryQuiz()
    {
        return $this->hasMany(UserMasteryQuiz::class, 'user_id')->where('due', '>', '5');
    }

    // public function candlyLevel()
    // {
    //     return $this->hasMany(StudentCandlyLevel::class, 'user_id');
    // }
    // public function currentCandlyLevel()
    // {
    //     return $this->hasOne(StudentCandlyLevel::class, 'user_id')->latest()->with('candlyLevel');
    // }


    public function sendMessage()
    {
        return $this->morphOne(Message::class, 'sender');
    }

    public function sendMessages()
    {
        return $this->morphMany(Message::class, 'sender');
    }

    public function recievedMessages()
    {
        return $this->morphMany(Message::class, 'reciver');
    }

    public function active(): bool
    {
        return $this->is_active === 1;
    }

    public function notActive(): bool
    {
        return $this->is_active === 0;
    }

    public function verified(): bool
    {
        return !is_null($this->email_verified_at);
    }

    public function notVerified(): bool
    {
        return is_null($this->email_verified_at);
    }
}
