<?php

namespace App\Models;

use App\Models\Level;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Unit extends Model
{
    use HasFactory;

    protected $fillable = [
        'level_id', 'number', 'title', 'is_active', 'status', 'icon'
    ];

    // public function level()
    // {
    //     return $this->belongsTo(Level::class, 'level_id')->with('course');
    // }
    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    public function lessons()
    {
        return $this->hasMany(Lesson::class, 'unit_id')->orderBy('id', 'DESC')->with('videos');
    }

    public function lesson()
    {
        return $this->hasOne(Lesson::class, 'unit_id')->with('videos');
    }

    public function flashCards()
    {
        return $this->hasManyDeepFromRelations($this->lessons(), (new Lesson())->flashCards())->withCount('userMastery');
    }
    public function getFlashCardAttribute()
    {
        return $this->lessons->sum(function ($lesson) {
            return $lesson->flashCards->count();
        });
    }
    public function getMasteryFlashCardAttribute()
    {
        return $this->flashCards->sum(function ($flashCard) {
            return $flashCard->user_mastery_count;
        });
    }
    public function getMasteryQuizAttribute()
    {
        return $this->flashCards->sum(function ($flashCard) {
            return $flashCard->user_mastery_quiz_due_count;
        });
    }
    public function getQuizQuestionsAttribute()
    {
        return $this->lessons->sum(function ($lesson) {
            return $lesson->questions_count;
        });
    }
}
