<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TestAnswer extends Model
{
    use HasFactory;

    protected $fillable= [
     'question_id','answer',
     'is_correct','status',
    ];


    public function question(){
        return $this->belongsTo(TestQuestion::class,'question_id');
    }

    public function audios(){

        return $this->morphOne(Audio::class,'audioable');
    }

   

    public function images(){

        return $this->morphOne(Image::class,'imageable');
    }
}
