<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Section extends Model
{
    use HasFactory;
    protected $fillable=[
        'title','description','page_id','sub_section'
     ];

     public function page(){
        return $this->belongsTo(Page::class,'page_id');
    }

    public function sectionItems(){
        return  $this->hasMany(SectionItem::class,'section_id');
    }

    public function images(){

        return $this->morphOne(Image::class,'imageable');
    }

}
