<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quiz extends Model
{
    use HasFactory;

    protected $fillable = [
        'degree', 'lesson_id', 'status'
    ];


    public function lesson()
    {
        return $this->belongsTo(Lesson::class, 'lesson_id')->with('unit');
    }

    public function quizStudents()
    {
        return $this->hasMany(QuizStudent::class, 'quiz_id');
    }

    public function questions()
    {
        return $this->hasMany(QuizQuestion::class, 'quiz_id')->with('answers');
    }
}
