<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LessonReview extends Model
{
    use HasFactory;
    protected $fillable = [
        'lesson_id',
        'user_id',
        'rate',
        'comment',
        'status'
    ];

    public function lesson()
    {
        return $this->belongsTo(Lesson::class, 'lesson_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }


    public static function calculateRatingPercentage($lessonId, int $rating)
    {
        $totalReviews = self::where('lesson_id', $lessonId)->count();

        if ($totalReviews == 0) {
            return 0;
        }

        $ratingCount = self::where('lesson_id', $lessonId)->where('rate', $rating)->count();
        $percentage = ($ratingCount / $totalReviews) * 100;

        return round($percentage, 2);
    }
}
