<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Symfony\Component\Console\Question\Question;

class Lesson extends Model
{

    use HasFactory;

    protected $fillable = [
        'unit_id',
        'number',
        'title',
        'description',
        'notes',
        'is_active',
        'status',
        'link',
    ];

    public function unit()
    {

        return $this->belongsTo(Unit::class, 'unit_id')->with('course');
    }

    public function flashCards()
    {
        return $this->hasMany(FlashCard::class, 'lesson_id')->with('audios', 'userMastery');
    }

    public function lessonFaqs()
    {
        return $this->hasMany(LessonFaq::class, 'lesson_id')->where('status', 1)->with('user');
    }

    public function lessonReviews()
    {
        return $this->hasMany(LessonReview::class, 'lesson_id')->with('user');
    }


    public function quiz()
    {
        return $this->hasOne(Quiz::class, 'lesson_id')->withCount('questions')->with('quizStudents');
    }

    public function quizStudent()
    {
        return $this->hasManyThrough(QuizStudent::class, Quiz::class)->where([['user_id', auth()->user()->id], ['medal', 1]]);
    }
    public function lessonStudent()
    {
        return $this->hasMany(LessonStudent::class, 'lesson_id')->where([['user_id', auth()->user()->id], ['status', 1]]);
    }

    public function questions()
    {
        return $this->hasManyThrough(QuizQuestion::class, Quiz::class);
    }
    public function audios()
    {

        return $this->morphOne(Audio::class, 'audioable');
    }

    public function videos()
    {

        return $this->morphOne(Video::class, 'videoable');
    }

    public function images()
    {

        return $this->morphOne(Image::class, 'imageable');
    }
    public function scopeWhereUnitId($query , $unit_id){
        return $query->where('unit_id' ,  $unit_id);
    }
}
