<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GuideSubCategory extends Model
{
    use HasFactory;
    protected $fillable=[
        'title',
        'guide_category_id'
    ];


    public function guideCategory(){
        return $this->belongsTo(GuideCategory::class,'guide_category_id');
    }

    public function guide(){
        return $this->hasMany(Guide::class,'guide_sub_category_id');
    }
}
