<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FlashCard extends Model
{
    use HasFactory;
    use \Staudenmeir\EloquentHasManyDeep\HasRelationships;
    protected $fillable= [
        'lesson_id','english_word','arabic_word','pronuciation','status'
    ];
    protected $appends = ['level'];


    public function lesson(){

        return $this->belongsTo(Lesson::class,'lesson_id')->with('unit');
    }

    public function audios(){

        return $this->morphOne(Audio::class,'audioable');
    }



    public function getLevelAttribute(){
     return $this->lesson->unit->level->id;
    }
   
    public function userMasteryFlashCard(){

      return  $this->hasMany(UserMasterFlashCard::class,'flash_card_id');
    }

    public function UserMastery(){

        return $this->hasMany(UserMasterFlashCard::class,'flash_card_id')
        ->where([['due','>=',5],['user_id',auth()->user()->id]]);
       
     }
    public function dueUserMasteryFlashCard(){

       return $this->hasMany(UserMasterFlashCard::class,'flash_card_id')
       ->where([['due','<=',5],['user_id',auth()->user()->id]])
       ->orWhere([['due','>',5],['updated_at','<=', Carbon::now()->subDays(2)->toDateTimeString()]]);
    }
   
    

}
