<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Course extends Model
{
    use \Staudenmeir\EloquentHasManyDeep\HasRelationships;
    use HasFactory;
    protected $append=[
   'FlashCard','Questions','CompletedLessons','CompletedMedal','MasteryFlashCard','MasteryQuiz'
    ];
    protected $fillable=[
       'title','code','type','price','discount',
       'icon','background_color','status','copy_write'
    ];

    // public function levels(){
    //     return $this->hasMany(Level::class,'course_id')->with('units');
    // }

    // public function level(){
    //     return $this->hasOne(Level::class,'course_id')->with('unit');
    // }
    public function units(){
        return $this->hasMany(Unit::class,'course_id')->with('lessons');
    }

    public function unit(){
        return $this->hasOne(Unit::class,'course_id')->with('lesson');
    }

    public function courseGoals (){
        return $this->hasMany(CourseGoal::class,'course_id');
    }

    public function coursefeatures (){
        return $this->hasMany(coursefeature::class,'course_id');
    }

    // public function units()
    // {
    //     return $this->hasManyThrough( Unit::class,Level::class);
    // }
    public function lessons()
    {
        return $this->hasManyThrough(Lesson::class,Unit::class);
    }

    public function packages()
    {
        return $this->belongsToMany(Package::class);
    }

    // public function lessons(){

    //  return $this->hasManyDeepFromRelations($this->units(), (new Unit())->lessons())->with('lessonReviews')->withCount('flashCards')->withCount('lessonStudent')->withCount('questions')->withCount('quizStudent');

    // }
    public function flashCards(){

        return $this->hasManyDeepFromRelations($this->lessons(), (new Lesson())->flashCards())->withCount('userMastery');

       }
       public function Reviews(){

        return $this->hasManyDeepFromRelations($this->lessons(), (new Lesson())->lessonReviews());

       }


    public function questions(){
        return $this->hasManyDeepFromRelations($this->lessons(), (new Lesson())->questions())->withCount('userMasteryQuizdue');
      }

    public function getFlashCardAttribute()
    {
        return $this->lessons->sum(function ($lesson) {
            return $lesson->flash_cards_count;
        });
    }

    public function getMasteryFlashCardAttribute()
    {
        return $this->flashCards->sum(function ($flashCard) {
            return $flashCard->user_mastery_count;
        });
    }
    public function getMasteryQuizAttribute()
    {
        return $this->flashCards->sum(function ($flashCard) {
            return $flashCard->user_mastery_quiz_due_count;
        });
    }


    public function getQuestionsAttribute()
    {

        return $this->lessons->sum(function ($lesson) {

            return $lesson->questions_count;
        });
    }

    public function getCompletedLessonsAttribute()
    {

        return $this->lessons->sum(function ($lesson) {

            return $lesson->lesson_student_count;
        });
    }
     public function getCompletedMedalAttribute()
     {

        return $this->lessons->sum(function ($lesson) {

           return $lesson->quiz_student_count;
        });
     }


     public function students(){
        return $this->hasMany(CourseStudent::class,'course_id');
     }


}
