<?php

namespace App\Http\Requests\Admin\Units;

use Illuminate\Foundation\Http\FormRequest;

class CreateUnitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            
            'course_id' => 'required|exists:courses,id',
            'icon'     => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title'    => 'required'
        ];
    }
}
