<?php

namespace App\Http\Requests\Admin\TestQuestions;

use Illuminate\Foundation\Http\FormRequest;

class CreateTestQuestionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
           'question' => 'required',
           'answer'=> 'required',
           'images.*'=>'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
           'audio.*'=>'mimes:application/octet-stream,audio/mpeg,mpga,mp3,wav',
           'type' => 'required',
        ];
    }
}
