<?php

namespace App\Http\Requests\Admin\Slider;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSliderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'page_id'  =>'required|exists:pages,id',
            'title'       =>  'required',
            'description' =>  'required',
            'image'    =>'image|mimes:webp,jpeg,png,jpg,gif,svg|max:2048'
       
        ];
    }
}
