<?php

namespace App\Http\Requests\Admin\Setting;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [

            'id'             =>  'required|exists:settings,id',
            'logo'           =>  'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'address'        =>  'required',
            'email'          =>  'required|email',
            'phone'          =>  'required|numeric',
            'policy'         =>  'required',
            'terms'          =>  'required',
            'facebook'       =>  'required',
            'level_check'    =>  'nullable',
            'twitter'        =>  'required',
            'instagram'      =>  'required',
            'linkedin'       =>  'required',
            'youtube'        =>  'required',
        ];
    }
}
