<?php

namespace App\Http\Requests\Admin\Seller;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSellerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string',
            'percentage' => 'required|integer|min:0|max:100',
            'email' => 'required|email|unique:sellers,email,' . $this->route()->seller->id,
            'phone' => 'required|string|unique:sellers,phone,' . $this->route()->seller->id,
            'code' => 'required|string|unique:sellers,code,' . $this->route()->seller->id,
        ];
    }
}
