<?php

namespace App\Http\Requests\Admin\SectionItem;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'section_id'  => 'required|exists:sections,id',
            'title'       =>  'required',
            'description' =>  'required',
            'icon'        =>  'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'icon_color'  =>  'required',
            'icon_background_color' =>  'required'
        ];
    }
}
