<?php

namespace App\Http\Requests\Admin\FlashCards;

use Illuminate\Foundation\Http\FormRequest;

class CreateFlashCardRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'lesson_id'=>'required|exists:lessons,id',
             'english_word'=>'required',
             'arabic_word'=> 'required',
             'audio' =>'required|mimes:mp3,wav,ogg|max:2048',
        ];
    }
}
