<?php

namespace App\Http\Repositories\Front;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Front\StudentInterface;
use App\Http\Traits\ImageTrait;
use App\Mail\DeactiveAccountMail;
use App\Models\Subscribe;

class StudentRepository implements StudentInterface
{
    use ImageTrait;
    protected $userModel;
    protected $subscribeModel;

    public function __construct(User $usermodel, Subscribe $subscribe)
    {
        $this->userModel = $usermodel;
        $this->subscribeModel = $subscribe;
    }

    public function edit()
    {
        $user = $this->userModel::find(auth()->user()->id);
        return view('Front.dashboard.pages.profile-setting', compact('user'));
    }

    public function subscribes()
    {
        $subscribes = $this->subscribeModel::where(['user_id' => auth()->user()->id, 'status' => 1])->with(['package'])->get();
        return view('Front.dashboard.pages.profile-subscribes', compact('subscribes'));
    }

    public function update($request)
    {
        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'user');
            $image = 'images/user/' . $images;
        }
        $user = $this->userModel::find($request->id);
        $user->update([

            'email' => $request->email,
            'name' => $request->name,
            'daily_goal_lesson' => $request->daily_goal_lesson,
            'daily_goal_medal' => $request->daily_goal_medal,
            'send_notification' => ($user->send_notification == 1 ?  0 : 1),
            'image'   => ($image ? $image : $user->image)


        ]);
        Alert::success('success', ' User  updated Successfully');
        return redirect()->back()->with('message', 'profile updated successfully');
    }
    public function changepassword()
    {
        $user = $this->userModel::find(auth()->user()->id);

        return view('Front.dashboard.pages.profile-possword', compact('user'));
    }
    public function updatepassword($request)
    {
        $user = $this->userModel::find(auth()->user()->id);
        $user->update([

            'password' => Hash::make($request->password),

        ]);
        Alert::success('success', ' User  updated Successfully');

        return redirect()->back()->with('message', 'password updated successfully');
    }


    public function deactiveAccount()
    {
        $user = $this->userModel::find(auth()->user()->id);

        Mail::to($user->email)->send(new DeactiveAccountMail($user->id));

        return redirect()->back()->with('message', 'email send to deactive account');
    }

    public function  deactive($user)
    {

        $user = $this->userModel::find($user)->delete();
        return redirect()->route('loginpage')->with('message', 'account deleted');
    }
}
