<?php

namespace App\Http\Repositories\Front;

use App\Models\Quiz;
use App\Models\Lesson;
use App\Models\QuizStudent;
use App\Models\CourseStudent;
use App\Models\LessonStudent;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Front\LessonQuizInterface;

class LessonQuizRepository implements LessonQuizInterface
{
    protected $quizModel;
    protected $quizStudentModel;
    protected $lessonStudent;
    protected $lessonModel;
    protected $courseStudentModel;

    public function __construct(Quiz $quiz, QuizStudent $quizStudent, LessonStudent $lessonStudent, Lesson $lesson, CourseStudent $courseStudent)
    {
        $this->quizModel = $quiz;
        $this->quizStudentModel = $quizStudent;
        $this->lessonStudent = $lessonStudent;
        $this->lessonModel = $lesson;
        $this->courseStudentModel = $courseStudent;
    }

    public function index($id)
    {
        $studentquizes = $this->quizStudentModel::where([['user_id', auth()->user()->id], ['status', 0]])->delete();

        $studentquiz = $this->quizStudentModel::create([
            'quiz_id' => $id,
            'user_id' => auth()->user()->id,
        ]);

        return view('Front.dashboard.pages.exam-1', compact('id', 'studentquiz'));
    }

    public function result($id)
    {
        $result = $this->quizStudentModel::with('quiz')->find($id);
        $lesson = $this->lessonModel::find($result->quiz->lesson_id);

        $lessonStudent = $this->lessonStudent::where([['lesson_id', '=', $result->quiz->lesson_id], ['user_id', '=', auth()->user()->id]])->first();

        $studentcourse = $this->courseStudentModel::where([['course_id', '=', $result->quiz->lesson->unit->level->course_id], ['user_id', '=', auth()->user()->id]])->first();

        if (is_null($studentcourse)) {
            $this->courseStudentModel::create([
                'course_id' => $result->quiz->lesson->unit->level->course_id,
                'user_id' => auth()->user()->id,
                'level_id' => $result->quiz->lesson->unit->level_id,
                'enroll_date' => date('Y-m-d H:i:s'),
            ]);
        }

        if ($lessonStudent) {
            $lessonStudent->update([
                'status' => 1,
                'end_date' => date('Y-m-d H:i:s'),
            ]);
        } else {
            $this->lessonStudent::create([
                'lesson_id' => $result->quiz->lesson_id,
                'user_id' => auth()->user()->id,
                'start_date' => date('Y-m-d H:i:s'),
                'status' => 1,
                'unit_id' => $lesson->unit->id,
                'level_id' => $lesson->unit->level->id,
                'end_date' => date('Y-m-d H:i:s'),
            ]);
        }

        return view('Front.dashboard.pages.result-1', compact('result', 'lesson'));
    }

    public function nextLesson($id)
    {
        $lesson = $this->lessonModel::find($id);

        $next_lesson = $this->lessonModel
            ::where([['id', '>', $id], ['unit_id', $lesson->unit_id]])
            ->orderBy('id')
            ->first();

        $next_lesson_unit = $this->lessonModel
            ::where([['id', '>', $id], ['unit_id', '>', $lesson->unit_id]])
            ->orderBy('id')
            ->first();

        $next_lesson_level = $this->lessonModel
            ::where([['id', '>', $id], ['unit_id', '>', $lesson->unit_id]])
            ->whereHas('unit', function ($q) use ($lesson) {
                $q->where('level_id', '>', $lesson->unit->level->id);
            })
            ->orderBy('id')
            ->first();

        $next_lesson_course = $this->lessonModel
            ::where([['id', '>', $id], ['unit_id', '>', $lesson->unit_id]])
            ->whereHas('unit.level', function ($q) use ($lesson) {
                $q->where('course_id', '>', $lesson->unit->level->course->id);
            })
            ->orderBy('id')
            ->first();

        if (!is_null($next_lesson_course)) {
            $course = $this->courseStudentModel::where('course_id', $next_lesson_course->unit->level->course->id)->first();

            if ($course) {
                $course->update([
                    'enroll_date' => date('Y-m-d H:i:s'),
                ]);
            } else {
                $this->courseStudentModel::create([
                    'user_id' => Auth::user()->id,
                    'course_id' => $next_lesson_course->unit->level->course->id,
                    'level_id' => $next_lesson_course->unit->level->id,
                    'enroll_date' => date('Y-m-d H:i:s'),
                ]);
            }
        } else {
            $course = $this->courseStudentModel
                ::where('user_id', auth()->user()->id)
                ->latest()
                ->first();
            return redirect()->route('front.dashboard.index', $course->course_id);
        }

        if ($next_lesson) {
            $lessonstu = $this->lessonStudent::where([['lesson_id', $next_lesson->id], ['user_id', auth()->user()->id]])->first();

            if ($lessonstu) {
                $lessonstu->update([
                    'start_date' => date('Y-m-d H:i:s'),
                ]);
            } else {
                $lessonStudent = $this->lessonStudent::create([
                    'lesson_id' => $next_lesson->id,
                    'unit_id' => $next_lesson->unit->id,
                    'level_id' => $next_lesson->unit->level->id,
                    'user_id' => auth()->user()->id,
                    'start_date' => date('Y-m-d H:i:s'),
                ]);
            }
            return redirect()->route('front.dashboard.lessonFlash', $next_lesson->id);
        } elseif ($next_lesson_unit) {
            $lessonstu = $this->lessonStudent::where([['lesson_id', $next_lesson_unit->id], ['user_id', auth()->user()->id]])->first();

            if ($lessonstu) {
                $lessonstu->update([
                    'start_date' => date('Y-m-d H:i:s'),
                ]);
            } else {
                $lessonStudent = $this->lessonStudent::create([
                    'lesson_id' => $next_lesson_unit->id,
                    'unit_id' => $next_lesson_unit->unit->id,
                    'level_id' => $next_lesson_unit->unit->level->id,
                    'user_id' => auth()->user()->id,
                    'start_date' => date('Y-m-d H:i:s'),
                ]);
            }
            return redirect()->route('front.dashboard.lessonFlash', $next_lesson_unit->id);
        } elseif ($next_lesson_level) {
            $lessonstu = $this->lessonStudent::where([['lesson_id', $next_lesson_level->id], ['user_id', auth()->user()->id]])->first();

            if ($lessonstu) {
                $lessonstu->update([
                    'start_date' => date('Y-m-d H:i:s'),
                ]);
            } else {
                $lessonStudent = $this->lessonStudent::create([
                    'lesson_id' => $next_lesson_level->id,
                    'unit_id' => $next_lesson_level->unit->id,
                    'level_id' => $next_lesson_level->unit->level->id,
                    'user_id' => auth()->user()->id,
                    'start_date' => date('Y-m-d H:i:s'),
                ]);
            }
            return redirect()->route('front.dashboard.lessonFlash', $next_lesson_level->id);
        } elseif ($next_lesson_course) {
            $lessonstu = $this->lessonStudent::where([['lesson_id', $next_lesson_course->id], ['user_id', auth()->user()->id]])->first();

            if ($lessonstu) {
                $lessonstu->update([
                    'start_date' => date('Y-m-d H:i:s'),
                ]);
            } else {
                $lessonStudent = $this->lessonStudent::create([
                    'lesson_id' => $next_lesson_course->id,
                    'unit_id' => $next_lesson_course->unit->id,
                    'level_id' => $next_lesson_course->unit->level->id,
                    'user_id' => auth()->user()->id,
                    'start_date' => date('Y-m-d H:i:s'),
                ]);
            }
            return redirect()->route('front.dashboard.lessonFlash', $next_lesson_course->id);
        } else {
            Alert::success('success', 'you finshed our courses congratilations ');
            return redirect()->back();
        }
    }

    public function redo($id)
    {
    }

    public function completeLesson($id)
    {
        $lesson = $this->lessonModel::find($id);
        $lessonStudent = $this->lessonStudent::where([['lesson_id', '=', $id], ['user_id', '=', auth()->user()->id]])->first();
        if ($lessonStudent) {
            $lessonStudent->update([
                'status' => 1,
            ]);

            return view('Front.dashboard.pages.result-2', compact('lesson'));
        }
    }
}
