<?php

namespace App\Http\Repositories\Front;

use App\Models\Video;
use App\Models\Review;
use App\Models\Slider;
use App\Models\Contact;
use App\Models\Section;
use App\Models\Setting;
use App\Models\Page;
use App\Models\RegisterVideo;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Front\FrontInterface;

class FrontRepository implements FrontInterface{

    protected $sectionModel;
    protected $settingModel;
    protected $sliderModel;
    protected $videoModel;
    protected $reviwModel;
    protected $contactModel;
    protected $registervideoModel;
    protected $pageModel;

    public function __construct(Section $section,
     Setting $setting ,Page $page ,Slider $slider ,RegisterVideo $registervideo ,Review  $review
     ,Contact $contact)
    {
        $this->sectionModel         =$section;
        $this->sliderModel          = $slider;
        $this->settingModel         =$setting;
        $this->registervideoModel   =$registervideo;
        $this->reviwModel           =$review;
        $this->pageModel            =$page;
        $this->contactModel         =$contact;
    }

public function index()
{
    $sections= $this->sectionModel::whereHas('page',function($q){
        $q->where('title','Home');
    })->with('sectionItems')->get();

    $sliders= $this->sliderModel::get();

    return view('index',compact('sections','sliders'));
}

public function about()
{
    $sections= $this->sectionModel::whereHas('page',function($q){
        $q->where('title','About Us');
    })->with('sectionItems')->get();
    $reviews= $this->reviwModel::take(3)->get();

    return view('Front.pages.About-Us',compact('sections','reviews'));
}

public function subpage($slug)
{
    $page = $this->pageModel::where('title', $slug)->first();

    return view('Front.pages.subpages',compact('page'));
}

public function contact(){
    $sections= $this->sectionModel::whereHas('page',function($q){
        $q->where('title','Contact');
    })->with('sectionItems')->get();

    return view('Front.pages.Contact-Us',compact('sections'));
}

public function  howToRegister(){
    $sections= $this->sectionModel::whereHas('page',function($q){
        $q->where('title','How to register');
    })->with('sectionItems')->get();
    return view('Front.pages.how-to-register',compact('sections'));
}

public function  video(){
    $videos=$this->registervideoModel::get();

    return view('Front.pages.video',compact('videos'));
}

public function  policy(){
    $setting =$this->settingModel::first();
    return view('Front.pages.privacyPolicy',compact('setting'));
}

public function  terms(){
    $setting =$this->settingModel::first();
      return view('Front.pages.terms',compact('setting'));
  }

  public function contactstore($request){

    $contact= $this->contactModel::create([
        'name'    =>$request->name,
        'email'   =>$request->email,
        'phone'   =>$request->phone,
        'subject' =>$request->subject,
        'message' =>$request->message


    ]);
    return redirect()->back()->with('message', 'sent successfully!');

  }


}
