<?php

namespace App\Http\Repositories\Admin;


use App\Models\UploadedFile;
use App\Http\Traits\FileTrait;
use App\Http\Traits\ImageTrait;
use App\Models\DownloadAttachement;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\UplodedFileInterface;

class uplodedFileRepository implements UplodedFileInterface
{

    use FileTrait;

    protected $uplodedFileModel;
    protected $downloadAttachementModel;


    public function __construct(UploadedFile $uplodedFile, DownloadAttachement $downloadAttachement)
    {
        $this->uplodedFileModel = $uplodedFile;
        $this->downloadAttachementModel = $downloadAttachement;
    }
    public function index()
    {
        $uplodedfiles =  $this->uplodedFileModel::get();
        return view('Admin.uplodedfile.index', compact('uplodedfiles'));
    }
    public function create()
    {
        $downloadattachements = $this->downloadAttachementModel::get();
        return view('Admin.uplodedfile.create', compact('downloadattachements'));
    }

    public function store($request)
    {

        if ($request->hasFile('link')) {
            $filename = time() . '.' . $request->link->extension();
            $links =  $this->uploadFile($request->link, $filename, 'uplodedFile');
            $link = 'storage/app/public/uplodedFile/' . $links;
        }
        $uplodedFile =  $this->uplodedFileModel::create([
            'download_attachement_id'        => $request->downloadattachement_id,
            'title'             =>  $request->title,
            'link'             =>  $link,
            'format'             =>  $request->link->extension(),

        ]);
        Alert::success('success', ' uplodedFile Added Successfully');
        return redirect()->route('admin.uplodedfile.index');
    }

    public function edit($id)
    {
        $uplodedfile = $this->uplodedFileModel::find($id);
        $downloadattachements = $this->downloadAttachementModel::get();
        return view('Admin.uplodedfile.edit', compact('uplodedfile', 'downloadattachements'));
    }

    public function update($request)
    {

        if ($request->hasFile('link')) {
            $filename = time() . '.' . $request->link->extension();
            $links =  $this->uploadFile($request->link, $filename, 'uplodedFile');
            $link = 'storage/app/public/uplodedFile/' . $links;
        }
        $uplodedFile =  $this->uplodedFileModel::find($request->id);
        // dd($request->link ? $request->link->extension() : $uplodedFile->format);
        $uplodedFile->update([
            'download_attachement_id'        => $request->downloadattachement_id,
            'title'              =>  $request->title,
            'link'               =>  $link  ?? $uplodedFile->link,
            'format'             =>  $request->link ? $request->link->extension() : $uplodedFile->format,

        ]);
        Alert::success('success', ' uplodedFile  updated Successfully');
        return redirect()->route('admin.uplodedfile.index');
    }

    public function  destroy($id)
    {
        $uplodedFile = $this->uplodedFileModel::find($id);

        if ($uplodedFile) {
            $uplodedFile->delete();
            return  1;
        }

        return 0;
    }
}
