<?php
namespace App\Http\Repositories\Admin;

use App\Models\Unit;
use App\Models\Course;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\UnitInterface;
use App\Http\Traits\ImageTrait;
use Illuminate\Support\Facades\DB;

class UnitRepository implements UnitInterface
{
    use ImageTrait;
    protected $unitModel;
    protected $courseModel;
    public function __construct(Unit $unit, Course $course)
    {
        $this->unitModel = $unit;
        $this->courseModel = $course;
    }
    public function index()
    {
        $units = $this->unitModel::with('course')->get();
        return view('Admin.unit.index', compact('units'));
    }

    public function search($request)
    {
        $units = $this->unitModel::where('title', 'like', '%' . $request->title . '%')->get();

        return view('Admin.unit.index', compact('units'));
    }

    public function create()
    {
        $courses = $this->courseModel::get();
        return view('Admin.unit.create', compact('courses'));
    }

    public function store($request)
    {
        try {
            DB::beginTransaction();
            if ($request->hasFile('icon')) {
                $filename = time() . '.' . $request->icon->extension();
                $icons = $this->uploadImage($request->icon, $filename, 'unit');
                $icon = 'images/unit/' . $icons;
            }

            $maxNumberUnit = $this->unitModel::WhereCourseId($request->course_id)->max('number');
            $unit = $this->unitModel::create([
                'course_id' => $request->course_id,
                'number' => ++$maxNumberUnit ,
                'title' => $request->title,
                'icon' => $icon,
            ]);
            DB::commit();
            Alert::success('success', ' Unit Added Successfully');
            return redirect()->route('admin.unit.index');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()
                ->back()
                ->withErrors([$e]);
        }
    }

    public function edit($id)
    {
        $unit = $this->unitModel::find($id);
        $courses = $this->courseModel::get();
        return view('Admin.unit.edit', compact('unit', 'courses'));
    }

    public function update($request)
    {
        if ($request->hasFile('icon')) {
            $filename = time() . '.' . $request->icon->extension();
            $icons = $this->uploadImage($request->icon, $filename, 'unit');
            $icon = 'images/unit/' . $icons;
        }
        $unit = $this->unitModel::find($request->id);
        $unit->update([
            'course_id' => $request->course_id,
            'number' => $request->number,
            'title' => $request->title,
            'icon' => $icon ?? $unit->icon,
        ]);
        Alert::success('success', ' Unit  updated Successfully');
        return redirect()->route('admin.unit.index');
    }

    public function destroy($id)
    {
        $unit = $this->unitModel::find($id);
        if ($unit) {
            $unit->delete();
            return 1;
        }
        return 0;
    }
}
