<?php

namespace App\Http\Repositories\Admin;


use App\Models\TestAnswer;
use App\Models\TestQuestion;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\TestQuestionInterface;
use App\Http\Traits\ImageTrait;
use GuzzleHttp\Psr7\Request;

class TestQuestionRepository implements TestQuestionInterface
{

    use ImageTrait;
    protected $testQuestionModel;
    protected $testAnswerModel;

    public function __construct(TestQuestion $testQuestion, TestAnswer $testAnswer)
    {

        $this->testQuestionModel = $testQuestion;
        $this->testAnswerModel = $testAnswer;
    }
    public function index()
    {
        $testQuestions =  $this->testQuestionModel::with('Answers')->get();

        return view('Admin.testquestion.index', compact('testQuestions'));
    }


    public function show($id)
    {
        $testQuestion = $this->testQuestionModel::with('answers')->find($id);
        return view('Admin.testquestion.show', compact('testQuestion'));
    }

    public function create()
    {

        return view('Admin.testquestion.create');
    }

    public function store($request)
    {
        DB::transaction(function () use ($request) {
            $testQuestion =  $this->testQuestionModel::create([
                'question' => $request->question,
                'type'     => $request->type,
            ]);
            if ($request->hasFile('images')) {
                foreach ($request->images as $key => $image) {
                    $filename = time() . $key . '.' . $image->extension();

                    $images =  $this->uploadImage($image, $filename, 'testquestionimage');
                    $name = 'images/testquestionimage/' . $images;

                    $testQuestion->images()->create([
                        'image' => $name,
                        'type' => 'image',
                    ]);
                }
            }

            if ($request->hasFile('audio')) {



                $filename = time() . '.' . $request->audio->extension();
                $audios =  $this->uploadImage($request->audio, $filename, 'testansweraudio');
                $name = 'images/testansweraudio/' . $audios;

                $testQuestion->audios()->create([
                    'audio' => $name,
                    'type' => 'audio',
                ]);
            }



            foreach ($request->answer as $key => $ans) {

                $answer = $this->testAnswerModel::create([
                    'answer'      => $ans['ans'],
                    'question_id' => $testQuestion->id,
                    'is_correct'  => isset($ans['correct']) ? 1 : 0,

                ]);

                if (isset($ans['image'])) {


                    $filename = time() . '.' . $ans['image']->extension();
                    $images =  $this->uploadImage($ans['image'], $filename, 'testanswerimage');
                    $name = 'images/testanswerimage/' . $images;

                    $answer->images()->create([
                        'image' => $name,
                        'type' => 'image',
                    ]);
                }
            }
        });


        Alert::success('success', ' TestQuestion Added Successfully');
        return redirect()->route('admin.testQuestion.index');
    }

    public function edit($id)
    {
        $testQuestion = $this->testQuestionModel::with('answers')->find($id);


        return view('Admin.testquestion.edit', compact('testQuestion'));
    }


    public function update($request)
    {
        DB::transaction(function () use ($request) {
            $testQuestion = $this->testQuestionModel::find($request->id);
            $testQuestion->update([
                'question' => $request->question,
            ]);
            if ($request->hasFile('images')) {


                $testQuestion->images()->delete();
                foreach ($request->images as $key => $image) {
                    $filename = time() . $key . '.' . $image->extension();
                    $images =  $this->uploadImage($image, $filename, 'testquestionimage');
                    $name = 'images/testquestionimage/' . $images;

                    $testQuestion->images()->create([
                        'image' => $name,
                        'type' => 'image',
                    ]);
                }
            }

            if ($request->hasFile('audio')) {


                $testQuestion->audios()->delete();
                $filename = time() . '.' . $request->audio->extension();
                $audios =  $this->uploadImage($request->audio, $filename, 'testansweraudio');
                $name = 'images/testansweraudio/' . $audios;

                $testQuestion->audios()->create([
                    'audio' => $name,
                    'type' => 'audio',
                ]);
            }
        });

        Alert::success('success', ' TestQuestion  updated Successfully');
        return redirect()->route('admin.testQuestion.index');
    }

    public function  destroy($id)
    {
        $testQuestion = $this->testQuestionModel::find($id);

        if ($testQuestion) {
            foreach ($testQuestion->answers as $answer) {
                $answer->images()->delete();
            }
            $testQuestion->audios()->delete();
            $testQuestion->images()->delete();
            $testQuestion->delete();
            return  1;
        }
        return  0;
    }

    public function  status($request)
    {
        $testQuestion = TestQuestion::find($request->id);
        if ($testQuestion->status == 1) {
            $testQuestion->status = 0;
        }else {
            $testQuestion->status = 1;
        }

        if ($testQuestion->save()) {
            Alert::success('success', ' TestQuestion  updated status Successfully');
            return 1;
        }else {
            return 0;
        }

    }
}
