<?php 
namespace App\Http\Repositories\Admin;



use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\TestAnswerInterface;
use App\Http\Traits\ImageTrait;
use App\Models\TestAnswer;

class TestAnswerRepository implements TestAnswerInterface{


    use ImageTrait;

protected $testAnswerModel;
public function __construct(  TestAnswer $testAnswer )
{
 
    $this->testAnswerModel =$testAnswer;
   
}

public function create($questionid){

    
    return view('Admin.testAnswer.create',compact('questionid'));


}

public function store($request){
    $testAnswer =  $this->testAnswerModel::create([
         'question_id'   => $request->question_id,
        'answer'         => $request->answer,
        'is_correct'     =>$request->correct,
     ]);

     if ($request->hasFile('image')) {
       

        
            $filename = time() . '.' . $request->image->extension();
        $images =  $this->uploadImage($request->image, $filename, 'testanswerimage');
        $name= 'images/testanswerimage/'.$images; 
        
        $testAnswer->images()->create([
            'image' => $name,
            'type' => 'image',
        ]);
    }

    Alert::success('success', ' ٍAnswer addes Successfully');
    return redirect()->route('admin.testQuestion.show', $testAnswer ->question_id);
}
public function edit($id){
  
    $testAnswer= $this->testAnswerModel::find($id);
   
    return view('Admin.testAnswer.edit',compact('testAnswer'));

}


public function update($request){
   
    $answer=$this->testAnswerModel::find($request->id);
    $answer->update([

       'answer'=> $request->answer,
       'is_correct'=>isset($request->correct) ? 1 : 0,
      ]);

      
    if (isset($request->image)) {
        $answer->images()->delete();

    $filename = time() . '.' . $request->image->extension();
    $images =  $this->uploadImage($request->image, $filename, 'testanswerimage');
    $name= 'images/testanswerimage/'.$images; 
    
    $answer->images()->create([
        'image' => $name,
        'type' => 'image',
    ]);
}

     
    Alert::success('success', ' ٍAnswer updated Successfully');
    return redirect()->route('admin.testQuestion.show',$answer->question_id);
}

public function  destroy($id){
    
    $answer=$this->testAnswerModel::find($id);
    if($answer){
        if($answer->images){$answer->images->delete();} 
        $answer->delete();
        
    }
  return redirect()->back();
}



}